﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Grupa_F
{
    public partial class Form1 : Form
    {
        double[,] podaci = new double[19864, 2];

        public Form1()
        {
            InitializeComponent();
        }

        private int[] PretvorbaKoordinata(double x, double y)
        {
            int[] koordinate = new int[2];
            double xMin = 15.93785;
            double xMax = 16.185188;
            double yMin = 45.768888;
            double yMax = 45.919225;
            double xv = (x - xMin) / (xMax - xMin) * (slika.Width);
            koordinate[0] = Convert.ToInt32(Math.Round(xv));
            double yv = (y - yMin) / (yMax - yMin) * (slika.Height);
            koordinate[1] = slika.Height - Convert.ToInt32(Math.Round(yv));
            return koordinate;
        }

        private void btnPrikaz_Click(object sender, EventArgs e)
        {
            slika.Refresh();
        }

        private void btnUcitaj_Click(object sender, EventArgs e)
        {
            try
            {
                StreamReader reader = new StreamReader("podaciF.txt");
                int trenutniRedak = 0;

                while (!reader.EndOfStream)
                {
                    string[] dijeloviLinije = reader.ReadLine().Split(';');

                    podaci[trenutniRedak, 0] = Convert.ToDouble(dijeloviLinije[0]);
                    podaci[trenutniRedak, 1] = Convert.ToDouble(dijeloviLinije[1]);

                    trenutniRedak++;
                }

                reader.Close();

                MessageBox.Show("Podaci su učitani!");
            }
            catch (Exception ex)
            {
                MessageBox.Show("Greška: " + ex.Message);
            }
        }

        private void slika_Paint(object sender, PaintEventArgs e)
        {
            int[] tockaZaCrtanje = new int[2];
            int radijus = 3;

            for (int i = 0; i < podaci.GetLength(0); i++)
            {
                tockaZaCrtanje = PretvorbaKoordinata(podaci[i, 0], podaci[i, 1]);

                e.Graphics.FillEllipse(Brushes.Black, tockaZaCrtanje[0] - (radijus / 2.0f), tockaZaCrtanje[1] - (radijus / 2.0f), radijus, radijus);
            }

            tockaZaCrtanje = PretvorbaKoordinata(podaci[0, 0], podaci[0, 1]);
            radijus = 20;
            e.Graphics.FillEllipse(Brushes.Red, tockaZaCrtanje[0] - (radijus / 2.0f), tockaZaCrtanje[1] - (radijus / 2.0f), radijus, radijus);


            if (txtIndeks.Text != "")
            {
                int zeljeniIndeks = Convert.ToInt32(txtIndeks.Text);
                tockaZaCrtanje = PretvorbaKoordinata(podaci[zeljeniIndeks, 0], podaci[zeljeniIndeks, 1]);
                e.Graphics.FillEllipse(Brushes.Green, tockaZaCrtanje[0] - (radijus / 2.0f), tockaZaCrtanje[1] - (radijus / 2.0f), radijus, radijus);
            }
        }
    }
}
